package co.carmentang.bonvoyage;


import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashMap;

public class MainActivity extends ListActivity {
    Intent intent;
    TextView albumName;
    DBController controller = new DBController(this);
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        ArrayList<HashMap<String, String>> animalList =  controller.getAllAnimals();
        if(animalList.size()!=0) {
            ListView lv = getListView();
            lv.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view,int position, long id) {
                    albumName = (TextView) view.findViewById(R.id.albumName);
                    String valAnimalId = albumName.getText().toString();
                    Intent  objIndent = new Intent(getApplicationContext(),EditAlbum.class);
                    objIndent.putExtra("albumName", valAnimalId);
                    startActivity(objIndent);
                }
            });
            ListAdapter adapter = new SimpleAdapter( MainActivity.this,animalList, R.layout.view_album_entry, new String[] { "albumId","albumName"}, new int[] {R.id.albumId, R.id.albumName});
            setListAdapter(adapter);
        }
    }
    public void showAddForm(View view) {
        Intent objIntent = new Intent(getApplicationContext(), NewAlbumForm.class);
        startActivity(objIntent);
    }
}